// MainWindow.cpp: Implementierungsdatei
//

//#ifdef _DEBUG
//#define new DEBUG_NEW
//#undef THIS_FILE
//static char THIS_FILE[] = __FILE__;
//#endif

#include "stdafx.h"
#include "resource.h"
#include "MainWindow.h"
#include "TheApp.h"
#include "InfoDialog.h"

/////////////////////////////////////////////////////////////////////////////
// MainWindow

static int windowW=640;	//400
static int windowH=480;	//340


CMainWindow::CMainWindow(LPCSTR ClassName)
{	 
	//Center the Window on the Screen
    int xoffset=(::GetSystemMetrics(SM_CXSCREEN) - windowW) / 2; 
	int yoffset=(::GetSystemMetrics(SM_CYSCREEN) - windowH) / 2;

	//Create the Window
	Create(ClassName,"Transparent Bitmap Animation with MFC",
		WS_OVERLAPPED|WS_SYSMENU|WS_MINIMIZEBOX,
		CRect(xoffset,yoffset,xoffset+windowW,yoffset+windowH)
		,NULL, "MAIN_MENU");	

	TheApp* tApp = (TheApp*)AfxGetApp();
    tApp->mw = this;

	CClientDC dc(this);

	//DC and BMPs are prepared
	memDC.CreateCompatibleDC(&dc);
	memBMP.CreateCompatibleBitmap(&dc, windowW, windowH);
	memDC.SelectObject(&memBMP);

	//load the bitmaps from the resource
	bgDC.CreateCompatibleDC(&dc);
	bgBMP.LoadBitmap(IDB_BACKGROUND);
	bgDC.SelectObject(&bgBMP);

	sprite[0].LoadBitmap(IDB_BALLOON);	
	sprite[1].LoadBitmap(IDB_CAR);	
	sprite[2].LoadBitmap(IDB_PLANE);	
	sprite[3].LoadBitmap(IDB_TRUCK);	
	sprite[4].LoadBitmap(IDB_WORKER);	
	
	psprite[0] = &sprite[0];	
	psprite[1] = &sprite[1];	
	psprite[2] = &sprite[2];
	psprite[3] = &sprite[3];	
	psprite[4] = &sprite[4];	

	m_dFPS = 0; 
	m_iFrame = 0;

	//our target frame rate
	m_dFrameRate = 70;	//35			

	m_dwTicksPerFrame = (int)(1000.0/(m_dFrameRate*1.1));	
	if(m_dwTicksPerFrame > 1000) m_dwTicksPerFrame = 1000;
	if(m_dwTicksPerFrame < 1) m_dwTicksPerFrame = 1;
}

CMainWindow::~CMainWindow()
{	
	memDC.DeleteDC();	
	bgDC.DeleteDC();	
	memBMP.DeleteObject();
}

BEGIN_MESSAGE_MAP(CMainWindow, CFrameWnd)
	//{{AFX_MSG_MAP(MainWindow)	
	ON_COMMAND(ID_HELP_INFOABOUT, OnHelpInfoabout)
	ON_COMMAND(ID_PROGRAM_EXIT, OnProgramExit)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// Behandlungsroutinen Nachrichten MainWindow 

void CMainWindow::TimerReset(int timerID)
{
	int i;

	_ASSERT(timerID == -1 || (timerID >=0 && timerID < 50));

	if(!timersinitialized) {
		timerID = -1;
		QueryPerformanceFrequency(&timerfreq);
		timefactor = 1000000.0 /  (double)(timerfreq.LowPart);
		timersinitialized = true;
	}

	if(timerID == -1) {
		for(i = 0; i < 50; i++) {
			QueryPerformanceCounter(&timercount[i]);
		}
	}
	else  QueryPerformanceCounter(&timercount[timerID]);

}

DWORD CMainWindow::TimerCheck(int timerID)
{
	LARGE_INTEGER *lpt1,t2;
//	_ASSERT(timerID >=0 && timerID < DVMAX_TIMERS);

	lpt1 = &timercount[timerID];
	QueryPerformanceCounter(&t2);

	if(lpt1->HighPart ==  t2.HighPart) 
		return 	(DWORD)((t2.LowPart -  lpt1->LowPart)*timefactor);
	else  return 	(DWORD)((0xffffffff- lpt1->LowPart +  t2.LowPart)*timefactor);
}

BOOL CMainWindow::CheckNextFrame()
{
 	static DWORD nexttick;								
	DWORD tick;
	DWORD count;				
	
	tick = GetTickCount();

	if(nexttick > tick + m_dwTicksPerFrame*2) 
		nexttick = tick + m_dwTicksPerFrame;
	if(tick < nexttick) return false;		
								
	if(!(m_iFrame % 30)) {
		count=TimerCheck(50-1);
		TimerReset(50-1);
		if(count <1) count = 1;
		m_dFPS = 1000000.0 / count * 30.0;
	}
	
	nexttick = GetTickCount() + m_dwTicksPerFrame;
	return true;
}

void CMainWindow::OnPaint() 
{
	CPaintDC dc(this);
	
	DrawStuff();
}

void CMainWindow::DrawStuff()
{
	if(!CheckNextFrame()) return;
	m_iFrame++;

	//Draw the background into the window
	memDC.BitBlt(0,0,windowW,windowH,&bgDC,0,0,SRCCOPY);
	
	//balloon
	static int x4=640;	x4--;
    if(x4<-100)	x4=windowW;
    psprite[0]->DrawTransparent(&memDC, x4, 80, RGB(0,0,0));

	//plain
	static int x5=220;	x5+=4;
    if(x5>windowW)	x5=-250;
    psprite[2]->DrawTransparent(&memDC, x5, 10, RGB(0,0,0));

	//car
	static int x1=80;	x1+=3;
    if(x1>windowW)	x1=-150;
	psprite[1]->DrawTransparent(&memDC, x1, 200, RGB(0,0,0));

	//truck
	static int x2=250;	x2+=2;
    if(x2>windowW)	x2=-150;
    psprite[3]->DrawTransparent(&memDC, x2, 260, RGB(0,0,0));

	//worker
	static int x3=350;	x3--;
    if(x3<-50)			x3=windowW;
    psprite[4]->DrawTransparent(&memDC, x3, 340, RGB(0,0,0));    

	//copy the memory bitmap to the screen
	CClientDC dc(this);    
    dc.BitBlt(0,0,windowW,windowH,&memDC,0,0,SRCCOPY);	
}

void CMainWindow::OnHelpInfoabout() 
{
	CInfoDialog id;
	id.DoModal();		
}

void CMainWindow::OnProgramExit() 
{
	DestroyWindow();	
}
