//TransBitmap.cpp 
//Class for drawing Transparent Bitmaps
//Based on the CCISBitmap class by 	Paul Reynolds 
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "TransBitmap.h"

//#ifdef _DEBUG
//#undef THIS_FILE
//static char THIS_FILE[]=__FILE__;
//#define new DEBUG_NEW
//#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

TransBitmap::TransBitmap()
{
	m_crBlack = 0;
	m_crWhite = RGB(255,255,255);
}

TransBitmap::~TransBitmap()
{

}

int TransBitmap::Width()
{
	BITMAP bm;
	GetBitmap(&bm);
	return bm.bmWidth;
}

int TransBitmap::Height()
{
	BITMAP bm;
	GetBitmap(&bm);
	return bm.bmHeight;
}

///////Function for transparent Blitting////////////

void TransBitmap::DrawTransparent(CDC * pDC, int x, int y, COLORREF crColour)
{
	COLORREF crOldBack = pDC->SetBkColor(m_crWhite);
	COLORREF crOldText = pDC->SetTextColor(m_crBlack);
	CDC dcImage, dcTrans;

	// Create two memory dcs for the image and the mask
	dcImage.CreateCompatibleDC(pDC);
	dcTrans.CreateCompatibleDC(pDC);

	// Select the image into the appropriate dc
	CBitmap* pOldBitmapImage = dcImage.SelectObject(this);

	// Create the mask bitmap
	CBitmap bitmapTrans;
	int nWidth = Width();
	int nHeight = Height();
	bitmapTrans.CreateBitmap(nWidth, nHeight, 1, 1, NULL);

	// Select the mask bitmap into the appropriate dc
	CBitmap* pOldBitmapTrans = dcTrans.SelectObject(&bitmapTrans);

	// Build mask based on transparent colour
	dcImage.SetBkColor(crColour);
	dcTrans.BitBlt(0, 0, nWidth, nHeight, &dcImage, 0, 0, SRCCOPY);

	// Do the work - True Mask method - cool if not actual display
	pDC->BitBlt(x, y, nWidth, nHeight, &dcImage, 0, 0, SRCINVERT);
	pDC->BitBlt(x, y, nWidth, nHeight, &dcTrans, 0, 0, SRCAND);
	pDC->BitBlt(x, y, nWidth, nHeight, &dcImage, 0, 0, SRCINVERT);

	// Restore settings
	dcImage.SelectObject(pOldBitmapImage);
	dcTrans.SelectObject(pOldBitmapTrans);
	pDC->SetBkColor(crOldBack);
	pDC->SetTextColor(crOldText);
}

///////Function for normal, non-transparent Blitting////////

void TransBitmap::Draw(CDC * pDC, int x, int y)
{	
	CDC dcImage;
	
	dcImage.CreateCompatibleDC(pDC);

	CBitmap* pOldBitmapImage = dcImage.SelectObject(this);

	int nWidth = Width();
	int nHeight = Height();

	pDC->BitBlt(x, y, nWidth, nHeight, &dcImage, 0, 0, SRCCOPY);

	// Restore settings
	dcImage.SelectObject(pOldBitmapImage);	
}
